<?php

$this->pageTitle = Yii::app()->name . ' - Panel nauczyciela';

$this->breadcrumbs = array(
	'Nieaktywni użytkownicy'
);

Yii::app()->clientScript->registerScript('form', '

	$(".selectDeselectAll").click(function(){
		if($(\'[id^="selected_group_"]:checked\').length == $(\'[id^="selected_group_"]\').length && $(\'[id^="selected_group_"]:checked\').length>0)
			$(\'[id^="selected_group_"]\').prop("checked", false);
		else
			$(\'[id^="selected_group_"]\').prop("checked", true);

		return false;
	});

	$("#activateMany").click(function(){
		$("#userActivationForm").attr("action", "'.$this->createAbsoluteUrl('/teacher/main/activateGroups').'");
		$("#userActivationForm").submit();
	});

	$(".activateSingle").click(function(){
		var companyId = $(this).attr("companyId");
		$(\'[id^="selected_group_"]\').prop("checked", false);
		$(\'[id="selected_group_\'+companyId+\'"]\').prop("checked", true);
		$("#userActivationForm").attr("action", "'.$this->createAbsoluteUrl('/teacher/main/activateGroups').'");
		$("#userActivationForm").submit();
	});

	$("#rejectMany").click(function(){
		var selectedGroups = new Array();
		$(\'[id^="selected_group_"]:checked\').each(function(){
			selectedGroups.push($(this).attr("companyId"));
		});

		if(selectedGroups.length)
			window.location = "'.$this->createAbsoluteUrl('/teacher/main/rejectGroups', array('companyIds'=>'company_ids_template')).'".replace("company_ids_template",selectedGroups.join());

		return false;
	});

	$(".rejectSingle").click(function(){
		window.location = "'.$this->createAbsoluteUrl('/teacher/main/rejectGroups', array('companyIds'=>'company_ids_template')).'".replace("company_ids_template",$(this).attr("companyId"));
	});

', CClientScript::POS_READY);

$activeDeactiveButton = false;
foreach ($classes as $class)
	$activeDeactiveButton |= count($class->nieaktywneFirmy) > 0

?>
<h1>Nieaktywni użytkownicy</h1>

<?php if(Yii::app()->user->hasFlash('groupActivated')): ?>
	<div class="flash-success">
		<?php echo Yii::app()->user->getFlash('groupActivated'); ?>
	</div>
<?php endif; ?>

<?php if ($activeDeactiveButton) : ?>
<a href="#" class="buttonS bGreen" id="activateMany">Aktywuj wybranych</a> |
<a href="#" class="buttonS bRed" id="rejectMany">Usuń wybranych</a>
<br/><br/><a class="selectDeselectAll" href="#">zaznacz/odznacz wszystkie grupy</a>
<?php endif; ?>

<form id="userActivationForm" method="POST" style="padding-top:30px">
	<?php foreach($classes as $class): ?>
		<?php
		echo '<h3>Klasa '.$class->nazwa.'</h3>'; ?>
		<?php if (!$activeDeactiveButton) : ?>
			<p><i>Brak użytkowników</i></p>
		<?php endif; ?>
		<?php $groupNr = 1;
			foreach($class->nieaktywneFirmy as $group):
				$lastGroup = end($group); ?>
			<div style="width:100%; border: 1px solid #E5F1F4; margin: 5px; padding: 5px; float: left;">
				<h4 style="margin-bottom: 0.50em;">Grupa nr <?php echo $groupNr++; ?></h4>
				<input name="Group[<?php echo $group->id ?>][selected]" id="selected_group_<?php echo $group->id ?>" companyId="<?php echo $group->id ?>" type="checkbox">
				<label for="selected_group_<?php echo $group->id ?>"><b>Zaznacz tę grupę</b></label> |
				<a href="#" class="activateSingle buttonS bGreen" companyId="<?php echo $group->id ?>">Aktywuj tę grupę</a> |
				<a href="#" class="rejectSingle buttonS bRed" companyId="<?php echo $group->id ?>">Odrzuć tę grupę</a><br />
				Przypisz grupę do: <br> 				
							
							<select id="assign_group_<?php echo $group->id; ?>" name="Group[<?php echo $group->id ?>][existingCompany]" style="width: 300px; margin-top: 10px">
									<option value="nowa"><?php echo 'Utwórz nową firmę.'; ?></option>
								<?php foreach($class->aktywneFirmy as $company): ?>
									<option value="<?php echo $company->id ?>"><?php echo 'Dopisz do: '.$company->getUserNames(); ?></option>
								<?php endforeach; ?>
							</select>
							<div id="hider" style="position:absolute; left: -1000px;">
								<input style="width: 0" type="radio" name="Group[<?php echo $group->id ?>][assign]" value="newCompany" checked="checked" id="assignToNewCompany_<?php echo $group->id ?>" />			
								<label style="font-size: 0;" for="assignToNewCompany_<?php echo $group->id ?>"><b>Nowej firmy</b></label>
								<input style="width: 0" type="radio" name="Group[<?php echo $group->id ?>][assign]" value="existingCompany" id="assignToExistingCompany_<?php echo $group->id ?>" />
								<label style="font-size: 0;" for="assignToExistingCompany_<?php echo $group->id ?>"><b>Istniejącej firmy</b></label>
							</div>

				<?php
					$this->widget('zii.widgets.grid.CGridView', array(
						'id'=>'parametry-gry-grid',
						'dataProvider'=> new CArrayDataProvider($group->uzytkownicy),
						'htmlOptions'=>array('class'=>'tDefault','style'=>'margin-top:15px'),
						'summaryText'=>'',
						'columns'=>array(
							array(
								'name'=>'imie',
								'header'=>'Imię'
							),
							array(
								'name'=>'nazwisko',
								'header'=>'Nazwisko'
							),
							array(
								'name'=>'email',
								'header'=>'E-mail'
							),
							array(
								'name'=>'pesel',
								'header'=>'PESEL'
							),
						),
					));
				?>
			</div>
		<?php endforeach; ?>
	<?php endforeach; ?>
</form>
<script type="text/javascript">
$( document ).ready(function() {

	<?php 
	foreach($classes as $class)
	{
		foreach($class->nieaktywneFirmy as $group)
		{
	?>

		$('#assign_group_<?php echo $group->id; ?>').change(function(){
			if($('#assign_group_<?php echo $group->id; ?>').val()!== 'nowa'){
				$('#assignToExistingCompany_<?php echo $group->id ?>').prop('checked',true);
				$('#assignToNewCompany_<?php echo $group->id ?>').prop('checked',false);
			}
			else
			{	
				$('#assignToExistingCompany_<?php echo $group->id ?>').prop('checked',false);
				$('#assignToNewCompany_<?php echo $group->id ?>').prop('checked',true);
			}
		});

	<?php
		}	
	}
	?>

});
</script>

<?php if ($activeDeactiveButton) : ?>
	<a class="selectDeselectAll" href="#">zaznacz/odznacz wszystkie grupy</a>
<?php endif; ?>
